#ifndef COMBINATORICS_H
#define COMBINATORICS_H

void find_allowed_spg(int allowed_spg[230], int* num_allowed_spg, int Z);

void find_allowed_positions_using_molecular_symmetry(char mol_sym[6],
                                    int Z,
                                    int Zpp);

void find_compatible_spg_positions(molecule *mol, int Z,
 COMPATIBLE_SPG compatible_spg[], int *num_compatible_spg,
 int thread_num);

void find_farthest_equivalent_atoms(molecule *mol,int atom_index[],\
                                        int* len_atom_index);



int check_pos_compatibility_using_std_orientations(crystal* xtal_1,
                              COMPATIBLE_AXES *comp_axes,
                              molecule* mol,
                              int hall_number,
                              float *mol_axes,
                              int num_axes,
                              float first_com[3],
                              int overlap_list[],
                              int len_overlap_list);

int check_overlap_xtal(crystal* xtal,
                       int overlap_list[],
                       int len_overlap_list,
                       int N);

/*
*function to check overlaps in a crystal using simple cartesian distance
* uses the overlap list to know location of symmetrically equivalent
* molecules
*/
int check_overlap_xtal_cartesian(crystal* xtal,
                                int overlap_list[],
                                int len_overlap_list,
                                int N);


int compute_average_axis(float axis1[3],float axis2[3], float avg[3]);
int compute_atom_average_xtal(crystal* xtal, int index1, int index2, float avg[3]);

void bring_molecules_to_origin(crystal* xtal);

int compute_cross_axis(float axis1[3],float axis2[3], float avg[3]);
int compute_atom_cross_xtal(crystal* xtal, int index1, int index2, float avg[3]);
void add_axis_to_mol_axes(float *mol_axes, int *num_axes, float axis[3]);

void find_possible_mol_axis(molecule *mol, float *mol_axes, int* num_axes,\
                            int eq_atoms[], int len_eq_atoms);


void find_overlap_list (crystal xtal,
                        float first_com[3],
                        float inverse_lattice_vectors[3][3],
                        int overlap_list[],
                        int *len_overlap_list,
                        int Z_gen,
                        int N);

#define MAX_SIZE 47

typedef struct
{
    int     num_of_positions;
    char    wyckoff_letter[MAX_SIZE];
    char    site_symmetry[MAX_SIZE][6];
    int     multiplicity[MAX_SIZE];
    int     first_position_rot[MAX_SIZE][3][3];
    float   first_position_trans[MAX_SIZE][3];
    float   primary_orientation[MAX_SIZE][3];
    float   secondary_orientation[MAX_SIZE][3];
}spg_positions_database;


static const spg_positions_database spg_positions[]=
{
/*spgnumber = 1  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 2  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","-1","-1","-1","-1","-1","-1","-1","-1"},

 .multiplicity = {2,1,1,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 3  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","2","2"},

 .multiplicity = {2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 4  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 5  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 6  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","m"},

 .multiplicity = {2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 7  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 8  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","m"},

 .multiplicity = {4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 9  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 10  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","2","2","2/m","2/m","2/m","2/m","2/m","2/m","2/m","2/m"},

 .multiplicity = {4,2,2,2,2,2,2,1,1,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 11  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","-1","-1","-1","-1"},

 .multiplicity = {4,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 12  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","2","-1","-1","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 13  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","-1","-1","-1","-1"},

 .multiplicity = {4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 14  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","-1","-1","-1","-1"},

 .multiplicity = {4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 15  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","-1","-1","-1","-1"},

 .multiplicity = {8,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 16  */
{
 .num_of_positions = 21,

 .wyckoff_letter="utsrqponmlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","2","2","2","2","2","2","222","222","222","222","222","222","222","222"},

 .multiplicity = {4,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 17  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","2","2"},

 .multiplicity = {4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 18  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 19  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 20  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 21  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","2","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 22  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","222","222","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.000000, 0.250000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 23  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 24  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","2","2"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 25  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","m","m","m","mm2","mm2","mm2","mm2"},

 .multiplicity = {4,2,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 26  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","m"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 27  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","2","2"},

 .multiplicity = {4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 28  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","2","2"},

 .multiplicity = {4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 29  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 30  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 31  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","m"},

 .multiplicity = {4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 32  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 33  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 34  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 35  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","m","2","mm2","mm2"},

 .multiplicity = {8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 36  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","m"},

 .multiplicity = {8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 37  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","2","2"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 38  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","m","m","mm2","mm2"},

 .multiplicity = {8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 39  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","2","2"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 40  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","2"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 41  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 42  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","m","2","mm2"},

 .multiplicity = {16,8,8,8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 43  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {16,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 44  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","m","mm2","mm2"},

 .multiplicity = {8,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 45  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 46  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","2"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 47  */
{
 .num_of_positions = 27,

 .wyckoff_letter="Azyxwvutsrqponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","m","m","m","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","mmm","mmm","mmm","mmm","mmm","mmm","mmm","mmm"},

 .multiplicity = {8,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 48  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","-1","-1","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 49  */
{
 .num_of_positions = 18,

 .wyckoff_letter="rqponmlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","2","2","2","2","222","222","222","222","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.250000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 50  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","-1","-1","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 51  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","m","2","2","mm2","mm2","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.500000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 52  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","-1","-1"},

 .multiplicity = {8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 53  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 54  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","2","2","-1","-1"},

 .multiplicity = {8,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.500000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 55  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","m","2","2","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 56  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","-1","-1"},

 .multiplicity = {8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.750000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 57  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","2","-1","-1"},

 .multiplicity = {8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.250000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 58  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","m","2","2","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 59  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","m","m","-1","-1","mm2","mm2"},

 .multiplicity = {8,4,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 60  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","-1","-1"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 61  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","-1","-1"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 62  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","-1","-1"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 63  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","m","m","2","-1","mm2","2/m","2/m"},

 .multiplicity = {16,8,8,8,8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 64  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","m","2","2","-1","2/m","2/m"},

 .multiplicity = {16,8,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 65  */
{
 .num_of_positions = 18,

 .wyckoff_letter="rqponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","m","2","mm2","mm2","mm2","mm2","mm2","mm2","2/m","2/m","mmm","mmm","mmm","mmm"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 66  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","2","2/m","2/m","2/m","2/m","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,4,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.250000, 0.750000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 67  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","2","2","2","mm2","2/m","2/m","2/m","2/m","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,8,4,4,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 68  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","2","-1","-1","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 69  */
{
 .num_of_positions = 16,

 .wyckoff_letter="ponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","2","2","2","mm2","mm2","mm2","222","2/m","2/m","2/m","mmm","mmm"},

 .multiplicity = {32,16,16,16,16,16,16,8,8,8,8,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.000000, 0.250000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.250000, 0.250000, 0.000000},
{0.250000, 0.000000, 0.250000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 70  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","2","-1","-1","222","222"},

 .multiplicity = {32,16,16,16,16,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.625000, 0.625000},
{0.125000, 0.125000, 0.125000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 71  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","-1","mm2","mm2","mm2","mm2","mm2","mm2","mmm","mmm","mmm","mmm"},

 .multiplicity = {16,8,8,8,8,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 72  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","-1","2/m","2/m","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 73  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","2","2","-1","-1"},

 .multiplicity = {16,8,8,8,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 74  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","m","2","2","mm2","2/m","2/m","2/m","2/m"},

 .multiplicity = {16,8,8,8,8,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.000000},
{0.250000, 0.250000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 75  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","4","4"},

 .multiplicity = {4,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 76  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 77  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","2","2"},

 .multiplicity = {4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 78  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 79  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","4"},

 .multiplicity = {8,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 80  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 81  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","2","-4","-4","-4","-4"},

 .multiplicity = {4,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 82  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","-4","-4","-4","-4"},

 .multiplicity = {8,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.750000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 83  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","4","4","2/m","2/m","4/m","4/m","4/m","4/m"},

 .multiplicity = {8,4,4,4,2,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 84  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","-4","-4","2/m","2/m","2/m","2/m"},

 .multiplicity = {8,4,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 85  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","-1","-1","4","-4","-4"},

 .multiplicity = {8,4,4,4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 86  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","-1","-1","-4","-4"},

 .multiplicity = {8,4,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 87  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","-1","4","-4","2/m","4/m","4/m"},

 .multiplicity = {16,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 88  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","-1","-1","-4","-4"},

 .multiplicity = {16,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.625000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 89  */
{
 .num_of_positions = 16,

 .wyckoff_letter="ponmlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","2","4","4","222","222","422","422","422","422"},

 .multiplicity = {8,4,4,4,4,4,4,4,2,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 90  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","2","4","222","222"},

 .multiplicity = {8,4,4,4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 91  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","2","2"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.375000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 92  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 93  */
{
 .num_of_positions = 16,

 .wyckoff_letter="ponmlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","2","2","2","222","222","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.750000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 94  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","2","2","222","222"},

 .multiplicity = {8,4,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 95  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","2","2"},

 .multiplicity = {8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.625000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 96  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 97  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","4","222","222","422","422"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 98  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","2","2","222","222"},

 .multiplicity = {16,8,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 99  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","m","m","m","mm2","4mm","4mm"},

 .multiplicity = {8,4,4,4,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 100  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","mm2","4"},

 .multiplicity = {8,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 101  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","2","mm2","mm2"},

 .multiplicity = {8,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 102  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","2","mm2"},

 .multiplicity = {8,4,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 103  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","4","4"},

 .multiplicity = {8,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 104  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","4"},

 .multiplicity = {8,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 105  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","m","mm2","mm2","mm2"},

 .multiplicity = {8,4,4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 106  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 107  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","m","mm2","4mm"},

 .multiplicity = {16,8,8,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 108  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","mm2","4"},

 .multiplicity = {16,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 109  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","mm2"},

 .multiplicity = {16,8,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 110  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","2"},

 .multiplicity = {16,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 111  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","2","mm2","mm2","222","222","-42m","-42m","-42m","-42m"},

 .multiplicity = {8,4,4,4,4,4,4,2,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 112  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","2","-4","-4","222","222","222","222"},

 .multiplicity = {8,4,4,4,4,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.250000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.500000, 0.500000, 0.250000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 113  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","2","mm2","-4","-4"},

 .multiplicity = {8,4,4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 114  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","-4","-4"},

 .multiplicity = {8,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 115  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","mm2","mm2","mm2","-42m","-42m","-42m","-42m"},

 .multiplicity = {8,4,4,4,4,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 116  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","-4","-4","222","222"},

 .multiplicity = {8,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.750000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 117  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","2","222","222","-4","-4"},

 .multiplicity = {8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 118  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","2","222","222","-4","-4"},

 .multiplicity = {8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.750000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 119  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","2","mm2","mm2","-42m","-42m","-42m","-42m"},

 .multiplicity = {16,8,8,8,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.750000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 120  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","2","222","-4","-4","222"},

 .multiplicity = {16,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 121  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","2","2","mm2","-4","222","-42m","-42m"},

 .multiplicity = {16,8,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 122  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","2","-4","-4"},

 .multiplicity = {16,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 123  */
{
 .num_of_positions = 21,

 .wyckoff_letter="utsrqponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","m","m","mm2","mm2","mm2","mm2","mm2","mm2","mm2","4mm","4mm","mmm","mmm","4/mmm","4/mmm","4/mmm","4/mmm"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,4,4,4,4,2,2,2,2,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 124  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","4","4","222","2/m","4/m","422","4/m","422"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 125  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","mm2","4","2/m","2/m","-42m","-42m","422","422"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 126  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","-1","4","-4","222","422","422"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 127  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","m","mm2","mm2","mm2","4","mmm","mmm","4/m","4/m"},

 .multiplicity = {16,8,8,8,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 128  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","2","4","222","2/m","4/m","4/m"},

 .multiplicity = {16,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 129  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","mm2","2/m","2/m","4mm","-42m","-42m"},

 .multiplicity = {16,8,8,8,8,4,4,4,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.500000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 130  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","-1","4","-4","222"},

 .multiplicity = {16,8,8,8,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 131  */
{
 .num_of_positions = 18,

 .wyckoff_letter="rqponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","2","mm2","mm2","mm2","mm2","mm2","mm2","mm2","-42m","-42m","mmm","mmm","mmm","mmm"},

 .multiplicity = {16,8,8,8,8,4,4,4,4,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 132  */
{
 .num_of_positions = 16,

 .wyckoff_letter="ponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","2","mm2","mm2","mm2","mm2","2/m","222","-42m","mmm","-42m","mmm"},

 .multiplicity = {16,8,8,8,8,8,4,4,4,4,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.500000, 0.500000, 0.250000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 133  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","-1","-4","222","222","222"},

 .multiplicity = {16,8,8,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.750000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 134  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","2","2","mm2","2/m","2/m","222","222","-42m","-42m"},

 .multiplicity = {16,8,8,8,8,8,8,4,4,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.750000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 135  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","2","2","222","2/m","-4","2/m"},

 .multiplicity = {16,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 136  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","m","m","2","mm2","mm2","mm2","-4","2/m","mmm","mmm"},

 .multiplicity = {16,8,8,8,4,4,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 137  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","m","2","-1","mm2","mm2","-42m","-42m"},

 .multiplicity = {16,8,8,8,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 138  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","2","2","mm2","2/m","2/m","-4","222"},

 .multiplicity = {16,8,8,8,8,4,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.750000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 139  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","2","mm2","mm2","mm2","mm2","2/m","4mm","-42m","mmm","4/mmm","4/mmm"},

 .multiplicity = {32,16,16,16,16,8,8,8,8,8,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 140  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","m","m","2","2","mm2","mm2","4","2/m","mmm","4/m","-42m","422"},

 .multiplicity = {32,16,16,16,16,8,8,8,8,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.250000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 141  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","2","mm2","2/m","2/m","-42m","-42m"},

 .multiplicity = {32,16,16,16,8,8,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.625000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 0.000000}
                        }

},
/*spgnumber = 142  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","2","-1","222","-4"},

 .multiplicity = {32,16,16,16,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.250000, 0.000000, 0.125000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.125000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},

/*spgnumber = 143  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","3","3","3"},

 .multiplicity = {3,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 144  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 145  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 146  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","3"},

 .multiplicity = {9,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 147  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","-1","-1","3","3","-3","-3"},

 .multiplicity = {6,3,3,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 148  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","-1","-1","3","-3","-3"},

 .multiplicity = {18,9,9,6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 149  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","2","2","3","3","3","32","32","32","32","32","32"},

 .multiplicity = {6,3,3,2,2,2,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.500000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 150  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","2","3","3","32","32"},

 .multiplicity = {6,3,3,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 151  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.833333},
{0.000000, 0.000000, 0.333333}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 152  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.833333},
{0.000000, 0.000000, 0.333333}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 153  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.166667},
{0.000000, 0.000000, 0.666667}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 154  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.166667},
{0.000000, 0.000000, 0.666667}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 155  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","2","3","32","32"},

 .multiplicity = {18,9,9,6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 156  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","m","3m","3m","3m"},

 .multiplicity = {6,3,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 157  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","3","3m"},

 .multiplicity = {6,3,2,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 158  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","3","3","3"},

 .multiplicity = {6,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 159  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","3","3"},

 .multiplicity = {6,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 160  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","m","3m"},

 .multiplicity = {18,9,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 161  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","3"},

 .multiplicity = {18,6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 162  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","2","2","3","2/m","2/m","3m","32","32","-3m","-3m"},

 .multiplicity = {12,6,6,6,4,3,3,2,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 163  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","-1","3","3","32","32","-3","32"},

 .multiplicity = {12,6,6,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.250000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 164  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","2","2/m","2/m","3m","3m","-3m","-3m"},

 .multiplicity = {12,6,6,6,3,3,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 165  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","-1","3","3","-3","32"},

 .multiplicity = {12,6,6,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 166  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","2","2/m","2/m","3m","-3m","-3m"},

 .multiplicity = {36,18,18,18,9,9,6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 167  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","-1","3","-3","32"},

 .multiplicity = {36,18,18,12,6,6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 168  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","3","6"},

 .multiplicity = {6,3,2,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 169  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 170  */
{
 .num_of_positions = 1,

 .wyckoff_letter="a",

 .site_symmetry = {"1"},

 .multiplicity = {6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 171  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 172  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {6,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 173  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","3","3"},

 .multiplicity = {6,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 174  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","3","3","3","-6","-6","-6","-6","-6","-6"},

 .multiplicity = {6,3,3,2,2,2,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.500000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 175  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","3","2/m","2/m","6","-6","-6","6/m","6/m"},

 .multiplicity = {12,6,6,6,4,3,3,2,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 176  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","-1","3","3","-6","-6","-3","-6"},

 .multiplicity = {12,6,6,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.250000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 177  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","3","222","222","6","32","32","622","622"},

 .multiplicity = {12,6,6,6,6,6,4,3,3,2,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 178  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {12,6,6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 179  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","2"},

 .multiplicity = {12,6,6},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.750000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 180  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","222","222","222","222"},

 .multiplicity = {12,6,6,6,6,6,6,3,3,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 181  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","2","222","222","222","222"},

 .multiplicity = {12,6,6,6,6,6,6,3,3,3,3},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 182  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","3","3","32","32","32","32"},

 .multiplicity = {12,6,6,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.750000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 183  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","m","m","mm2","3m","6mm"},

 .multiplicity = {12,6,6,3,2,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 184  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","2","3","6"},

 .multiplicity = {12,6,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 185  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","3","3m"},

 .multiplicity = {12,6,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 186  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","m","3m","3m"},

 .multiplicity = {12,6,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 187  */
{
 .num_of_positions = 15,

 .wyckoff_letter="onmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","mm2","mm2","3m","3m","3m","-6m2","-6m2","-6m2","-6m2","-6m2","-6m2"},

 .multiplicity = {12,6,6,6,3,3,2,2,2,1,1,1,1,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.500000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 188  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","2","3","3","3","-6","32","-6","32","-6","32"},

 .multiplicity = {12,6,6,4,4,4,2,2,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{-1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.250000},
{0.666667, 0.333333, 0.000000},
{0.333333, 0.666667, 0.250000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000}
                        }

},
/*spgnumber = 189  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","m","3","mm2","mm2","3m","-6","-6","-6m2","-6m2"},

 .multiplicity = {12,6,6,6,4,3,3,2,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 190  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","3","3","-6","-6","-6","32"},

 .multiplicity = {12,6,6,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.666667, 0.333333, 0.250000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 191  */
{
 .num_of_positions = 18,

 .wyckoff_letter="rqponmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","m","mm2","mm2","mm2","mm2","mm2","3m","mmm","mmm","6mm","-6m2","-6m2","6/mmm","6/mmm"},

 .multiplicity = {24,12,12,12,12,6,6,6,6,6,4,3,3,2,2,2,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.500000, 0.000000, 0.500000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.500000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 192  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","3","2/m","222","6","-6","32","6/m","622"},

 .multiplicity = {24,12,12,12,12,8,6,6,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 193  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","3","mm2","2/m","3m","32","-6","-3m","-6m2"},

 .multiplicity = {24,12,12,12,8,6,6,4,4,4,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 194  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","mm2","2/m","3m","3m","-6m2","-6m2","-6m2","-3m"},

 .multiplicity = {24,12,12,12,6,6,4,4,2,2,2,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{2.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.333333, 0.666667, 0.750000},
{0.333333, 0.666667, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 1.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, -1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 195  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","2","2","2","2","3","222","222","23","23"},

 .multiplicity = {12,6,6,6,6,4,3,3,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 196  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","23","23","23","23"},

 .multiplicity = {48,24,24,16,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 197  */
{
 .num_of_positions = 6,

 .wyckoff_letter="fedcba",

 .site_symmetry = {"1","2","2","3","222","23"},

 .multiplicity = {24,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 198  */
{
 .num_of_positions = 2,

 .wyckoff_letter="ba",

 .site_symmetry = {"1","3"},

 .multiplicity = {12,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 199  */
{
 .num_of_positions = 3,

 .wyckoff_letter="cba",

 .site_symmetry = {"1","2","3"},

 .multiplicity = {24,12,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 200  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","3","mm2","mm2","mm2","mm2","mmm","mmm","m-3","m-3"},

 .multiplicity = {24,12,12,8,6,6,6,6,3,3,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 201  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","222","-3","-3","23"},

 .multiplicity = {24,12,12,8,6,4,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 202  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","2","3","mm2","2/m","23","m-3","m-3"},

 .multiplicity = {96,48,48,32,24,24,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 203  */
{
 .num_of_positions = 7,

 .wyckoff_letter="gfedcba",

 .site_symmetry = {"1","2","3","-3","-3","23","23"},

 .multiplicity = {96,48,32,16,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.625000, 0.625000},
{0.125000, 0.125000, 0.125000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 204  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","m","3","mm2","mm2","-3","mmm","m-3"},

 .multiplicity = {48,24,16,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 205  */
{
 .num_of_positions = 4,

 .wyckoff_letter="dcba",

 .site_symmetry = {"1","3","-3","-3"},

 .multiplicity = {24,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 206  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","3","-3","-3"},

 .multiplicity = {48,24,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 207  */
{
 .num_of_positions = 11,

 .wyckoff_letter="kjihgfedcba",

 .site_symmetry = {"1","2","2","2","3","4","4","422","422","432","432"},

 .multiplicity = {24,12,12,12,8,6,6,3,3,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 208  */
{
 .num_of_positions = 13,

 .wyckoff_letter="mlkjihgfedcba",

 .site_symmetry = {"1","2","2","2","2","2","3","222","222","222","32","32","23"},

 .multiplicity = {24,12,12,12,12,12,8,6,6,6,4,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.500000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 209  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","2","2","2","3","4","222","23","432","432"},

 .multiplicity = {96,48,48,48,32,24,24,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 210  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","32","32","23","23"},

 .multiplicity = {96,48,48,32,16,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.625000, 0.625000},
{0.125000, 0.125000, 0.125000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 211  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","2","2","2","3","4","222","32","422","432"},

 .multiplicity = {48,24,24,24,16,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.500000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 212  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","3","32","32"},

 .multiplicity = {24,12,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.625000, 0.625000},
{0.125000, 0.125000, 0.125000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000}
                        }

},
/*spgnumber = 213  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","3","32","32"},

 .multiplicity = {24,12,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.875000, 0.875000, 0.875000},
{0.375000, 0.375000, 0.375000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000}
                        }

},
/*spgnumber = 214  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","3","222","222","32","32"},

 .multiplicity = {48,24,24,24,16,12,12,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.000000, 0.250000},
{0.125000, 0.000000, 0.250000},
{0.875000, 0.875000, 0.875000},
{0.125000, 0.125000, 0.125000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000}
                        }

},
/*spgnumber = 215  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","mm2","mm2","3m","-42m","-42m","-43m","-43m"},

 .multiplicity = {24,12,12,6,6,4,3,3,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 216  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","m","mm2","mm2","3m","-43m","-43m","-43m","-43m"},

 .multiplicity = {96,48,24,24,16,4,4,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 217  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","m","2","mm2","-4","3m","-42m","-43m"},

 .multiplicity = {48,24,24,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 218  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","2","3","-4","-4","222","23"},

 .multiplicity = {24,12,12,12,8,6,6,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.500000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 219  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","-4","-4","23","23"},

 .multiplicity = {96,48,48,32,24,24,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 220  */
{
 .num_of_positions = 5,

 .wyckoff_letter="edcba",

 .site_symmetry = {"1","2","3","-4","-4"},

 .multiplicity = {48,24,16,12,12},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.875000, 0.000000, 0.250000},
{0.375000, 0.000000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 221  */
{
 .num_of_positions = 14,

 .wyckoff_letter="nmlkjihgfedcba",

 .site_symmetry = {"1","m","m","m","mm2","mm2","mm2","3m","4mm","4mm","4/mmm","4/mmm","m-3m","m-3m"},

 .multiplicity = {48,24,24,24,12,12,12,8,6,6,3,3,1,1},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 222  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","2","3","4","-4","-3","422","432"},

 .multiplicity = {48,24,24,16,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 223  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","2","3","mm2","mm2","mm2","32","-42m","-42m","mmm","m-3"},

 .multiplicity = {48,24,24,16,12,12,12,8,6,6,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000},
{0.250000, 0.500000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 224  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","2","2","2","mm2","222","3m","-42m","-3m","-3m","-43m"},

 .multiplicity = {48,24,24,24,24,12,12,8,6,4,4,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.500000, 0.500000},
{0.750000, 0.750000, 0.750000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 225  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","mm2","mm2","mm2","3m","4mm","mmm","-43m","m-3m","m-3m"},

 .multiplicity = {192,96,96,48,48,48,32,24,24,8,4,4},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.500000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.250000, 0.250000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 226  */
{
 .num_of_positions = 10,

 .wyckoff_letter="jihgfedcba",

 .site_symmetry = {"1","m","2","3","4","mm2","4/m","-42m","m-3","432"},

 .multiplicity = {192,96,96,64,48,48,24,24,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.250000, 0.250000},
{0.250000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.250000, 0.250000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 227  */
{
 .num_of_positions = 9,

 .wyckoff_letter="ihgfedcba",

 .site_symmetry = {"1","2","m","mm2","3m","-3m","-3m","-43m","-43m"},

 .multiplicity = {192,96,96,48,32,16,16,8,8},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.625000, 0.625000, 0.625000},
{0.125000, 0.125000, 0.125000},
{0.500000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        }

},
/*spgnumber = 228  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","-4","-3","32","23"},

 .multiplicity = {192,96,96,64,48,32,32,16},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.000000},
{0.375000, 0.375000, 0.375000},
{0.125000, 0.125000, 0.125000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 229  */
{
 .num_of_positions = 12,

 .wyckoff_letter="lkjihgfedcba",

 .site_symmetry = {"1","m","m","2","mm2","mm2","3m","4mm","-42m","-3m","4/mmm","m-3m"},

 .multiplicity = {96,48,48,48,24,24,16,12,12,8,6,2},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.500000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.250000, 0.000000, 0.500000},
{0.250000, 0.250000, 0.250000},
{0.000000, 0.500000, 0.500000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{0.000000, 1.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000}
                        }

},
/*spgnumber = 230  */
{
 .num_of_positions = 8,

 .wyckoff_letter="hgfedcba",

 .site_symmetry = {"1","2","2","3","-4","222","32","-3"},

 .multiplicity = {96,48,48,32,24,24,16,16},

 .first_position_rot = {
{{1.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,0.000000,1.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,1.000000,0.000000},{0.000000,-1.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000},{1.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}} ,
{{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000},{0.000000,0.000000,0.000000}}
                        },

 .first_position_trans = {
{0.000000, 0.000000, 0.000000},
{0.125000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.250000},
{0.000000, 0.000000, 0.000000},
{0.375000, 0.000000, 0.250000},
{0.125000, 0.000000, 0.250000},
{0.125000, 0.125000, 0.125000},
{0.000000, 0.000000, 0.000000}
                        },

.primary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 0.000000, 0.000000},
{1.000000, 1.000000, 1.000000},
{1.000000, 1.000000, 1.000000}
                        },

.secondary_orientation = {
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 0.000000, 0.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 1.000000, -1.000000},
{0.000000, 0.000000, 0.000000}
                        }

}

};



#endif
